/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.subgui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;

@OnlyIn(value=Dist.CLIENT)
public abstract class SubGuiBox
extends GuiComponent
implements ISubGuiBox {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("integrateddynamics", (String)IntegratedDynamics._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "sub_gui.png");
    private final Box type;
    protected List<Button> buttonList = Lists.newArrayList();
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();

    public SubGuiBox(Box type) {
        this.type = type;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        this.buttonList.clear();
        this.subGuiHolder.init(guiLeft, guiTop);
    }

    public void drawScreen(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderBg(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        int currentHeight;
        int i;
        int currentWidth;
        int textureWidth;
        RenderHelpers.bindTexture((ResourceLocation)TEXTURE);
        int textureHeight = textureWidth = 19;
        int x = guiLeft + this.getX();
        int y = guiTop + this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int tx = this.type.getX();
        int ty = this.type.getY();
        this.m_93228_(matrixStack, x, y, tx, tx, 1, 1);
        this.m_93228_(matrixStack, x + width - 1, y, tx + textureWidth - 1, ty, 1, 1);
        this.m_93228_(matrixStack, x, y + height - 1, 0, tx + textureHeight - 1, ty + 1, 1);
        this.m_93228_(matrixStack, x + width - 1, y + height - 1, tx + textureWidth - 1, ty + textureHeight - 1, 1, 1);
        for (i = 1; i < width - 1; i += currentWidth) {
            currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
            this.m_93228_(matrixStack, x + i, y, tx + 1, ty, currentWidth, 1);
            this.m_93228_(matrixStack, x + i, y + height - 1, tx + 1, ty + textureHeight - 1, currentWidth, 1);
        }
        for (i = 1; i < height - 1; i += currentHeight) {
            currentHeight = Math.max(1, Math.min(height - i, textureHeight - 2) - 1);
            this.m_93228_(matrixStack, x, y + i, tx, ty + 1, 1, currentHeight);
            this.m_93228_(matrixStack, x + width - 1, y + i, tx + textureWidth - 1, ty + 1, 1, currentHeight);
        }
        for (i = 1; i < width - 1; i += currentWidth) {
            int currentHeight2;
            currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
            for (int j = 1; j < height - 1; j += currentHeight2) {
                currentHeight2 = Math.max(1, Math.min(height - j, textureHeight - 2) - 1);
                this.m_93228_(matrixStack, x + i, y + j, tx + 1, ty + 1, currentWidth, currentHeight2);
            }
        }
        this.drawScreen(matrixStack, mouseX, mouseY, partialTicks);
        this.subGuiHolder.renderBg(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        return this.subGuiHolder.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        return this.subGuiHolder.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            Button guibutton = this.buttonList.get(i);
            if (!guibutton.m_6375_(mouseX, mouseY, mouseButton)) continue;
            guibutton.m_7435_(Minecraft.m_91087_().m_91106_());
            this.actionPerformed(guibutton);
            return true;
        }
        return false;
    }

    protected void actionPerformed(Button guibutton) {
    }

    public static enum Box {
        LIGHT(0, 0),
        DARK(0, 19);

        private final int x;
        private final int y;

        private Box(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class Base
    extends SubGuiBox {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public Base(Box type, int x, int y, int width, int height) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
        }

        @Override
        public void tick() {
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            return false;
        }

        @Override
        public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
            return false;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }
}

